#ifndef PWM_H
#define PWM_H

enum PwmMod {ForceLow = 0, ForceHi = 1, ActiveHi = 2, ActiveLow = 3};
// <<< Use Configuration Wizard in Context Menu >>>
// <o> Set MPWM SWAP <0x00=> MDSF05/MDSF40 <0x70=> MDSFA0
#define SWAP 0x00

// <h> Set MPWMDATA
// <i> The frequency of MPWMDATA is 48MHz
// <o> Set PWM Frequency (unit : Hz) <12000-40000 : 10>
// <i> unit : Hz
// </h>
#define PWM_FREQ 20000
#define MPWMDATA_REGS (uint16) ((48000000/PWM_FREQ)/2)

// <h> Set MPWMINV
// <o.0> U INV <0=> Non-Inverse <1=> Inverse
// <o.1> X INV <0=> Non-Inverse <1=> Inverse
// <o.2> V INV <0=> Non-Inverse <1=> Inverse
// <o.3> Y INV <0=> Non-Inverse <1=> Inverse
// <o.4> W INV <0=> Non-Inverse <1=> Inverse
// <o.5> Z INV <0=> Non-Inverse <1=> Inverse
// </h>
 #define MPWMINV_REGS 0x00
 
// <h> Set MPWMDB
// <i> The frequency of MPWMDB is 48MHz
// <o> Set Deadband Time 
// <0x30=> Deadband Time 1us
// <0x60=> Deadband Time 2us
// <0x90=> Deadband Time 3us
// <0xC0=> Deadband Time 4us
// <0xF0=> Deadband Time 5us
// <i> 0x30 : 48MHz * 48 = 1us
// </h>
#define MPWMDB_REGS 0x30 

#define PWM_Frequency 	PWM_FREQ
#define PWM_Counter 	MPWMDATA_REGS
// 1rps (rad/sec) = 1/60 rpm, w = 2Pi = 1rps
// 0 ~ 24512 is the motor Angle 0 ~ 360 deg
// Set AngleBase formula : AngleBase = 24512 * (1/PWM_Frequency) * (1/60) * 32767
//#define AngleBase (long) ((float)(24512 * (1/PWM_Frequency) * (1/60)) * 32767)
#define AngleBase (long) 13386411/PWM_Frequency

// <o> Set AngleBaseShift <0-8>
#define AngleBaseShift 0
// <<< end of configuration section >>>

extern void PWM_SetBreakForce (void);
extern void PWM_SetBreak (void);
extern void PWM_SetAllOff (void);
extern void PWM_SetActive (void);
extern void PWM_Init (void);
extern void PWM_Duty (unsigned int duty);

extern void SwitchPhase(unsigned short dirUVW);
extern void PWMSet(unsigned short uvw_number);

#endif